Locking on the current object instance (i.e. `this`), or on a `Type` object increases the chance of deadlocks because any
other thread could acquire (or attempt to acquire) the same lock for another unrelated purpose. 

Instead, a new, private `object` should be created and used for the lock.

## Noncompliant Code Example

<pre>
public void MyLockingMethod()
{
  lock (this) // Noncompliant
  {
    // ...
  }
}
</pre>

## Compliant Solution

<pre>
object lockObj = new object();

public void MyLockingMethod()
{
  lock (lockObj)
  {
    // ...
  }
}
</pre>