Calling the `!` or `~` prefix operator twice does nothing: the second invocation undoes the first. Such mistakes are
typically caused by accidentally double-tapping the key in question without noticing.

Either this is a bug, if the operator was actually meant to be called once, or misleading if done on purpose.

## Noncompliant Code Example

<pre>
int v1 = 0;
bool v2 = false;

var v3 = !!v1; // Noncompliant
var v4 = ~~v2; // Noncompliant
</pre>

## Compliant Solution

<pre>
int v1 = 0;
bool v2 = false;

var v3 = !v1;
var v4 = ~v2;
</pre>