When a non-`static` class field is annotated with `ThreadStatic`, the code seems to show that the field can have different
values for different calling threads, but that's not the case, since the `ThreadStatic` attribute is simply ignored on
non-`static` fields. 

So `ThreadStatic` should either be removed or replaced with a use of the `ThreadLocal<T>` class, which gives a similar
behavior for non-`static` fields.

## Noncompliant Code Example

<pre>
public class MyClass
{
  [ThreadStatic]  // Noncompliant
  private int count = 0;

  // ...
}
</pre>

## Compliant Solution

<pre>
public class MyClass
{
  private int count = 0;

  // ...
}
</pre>

or

<pre>
public class MyClass
{
  private readonly ThreadLocal
 <int>
   count = new ThreadLocal
  <int>
   (); public int Count { get { return count.Value; } set { count.Value = value; } } // ... } 
  </int>
 </int></pre>