There's no point in chaining multiple `OrderBy` calls in a LINQ; only the last one will be reflected in the result because each
subsequent call completely reorders the list. Thus, calling `OrderBy` multiple times is a performance issue as well, because all of the
sorting will be executed, but only the result of the last sort will be kept.

Instead, use `ThenBy` for each call after the first. 

## Noncompliant Code Example

<pre>
var x = personList
  .OrderBy(person =&gt; person.Age)
  .OrderBy(person =&gt; person.Name)  // Noncompliant
  .ToList();  // x is sorted by Name, not sub-sorted
</pre>

## Compliant Solution

<pre>
var x = personList
  .OrderBy(person =&gt; person.Age)
  .ThenBy(person =&gt; person.Name)
  .ToList();
</pre>