There is no point in providing a default value for a parameter if callers are required to provide a value for it anyway. Thus,
`[DefaultParameterValue]` should always be used in conjunction with `[Optional]`.

## Noncompliant Code Example

<pre>
public void MyMethod([DefaultParameterValue(5)] int j) //Noncompliant, useless
{
  Console.WriteLine(j);
}
</pre>

## Compliant Solution

<pre>
public void MyMethod(int j = 5)
{
  Console.WriteLine(j);
}
</pre>

or

<pre>
public void MyMethod([DefaultParameterValue(5)][Optional] int j)
{
  Console.WriteLine(j);
}
</pre>