The use of `[DefaultValue]` with `[Optional]` has no more effect than `[Optional]` alone. That's because
`[DefaultValue]` doesn't actually do anything; it merely indicates the intent for the value. More than likely, `[DefaultValue]`
was used in confusion instead of `[DefaultParameterValue]`.

## Noncompliant Code Example

<pre>
class MyClass
{
    public void DoStuff([Optional][DefaultValue(4)]int i, int j = 5)  // Noncompliant
    {
        Console.WriteLine(i);
    }

    public static void Main()
    {
        new MyClass().DoStuff(); // prints 0
    }
}
</pre>

## Compliant Solution

<pre>
class MyClass
{
    public void DoStuff([Optional][DefaultParameterValue(4)]int i, int j = 5)
    {
        Console.WriteLine(i);
    }

    public static void Main()
    {
        new MyClass().DoStuff(); // prints 4
    }
}
</pre>