When declaring a Windows Communication Foundation (WCF) `OperationContract` method one-way, that service method won't return any result,
not even an underlying empty confirmation message. These are fire-and-forget methods that are useful in event-like communication. Specifying a return
type therefore does not make sense.

## Noncompliant Code Example

<pre>
[ServiceContract]
interface IMyService
{
  [OperationContract(IsOneWay = true)]
  int SomethingHappened(int parameter); // Noncompliant
}
</pre>

## Compliant Solution

<pre>
[ServiceContract]
interface IMyService
{
  [OperationContract(IsOneWay = true)]
  void SomethingHappened(int parameter);
}
</pre>

## Exceptions

The rule doens't report if `OperationContractAttribute.AsyncPattern` is set to `true`.