Using `Type.Assembly` to get the current assembly is nearly free in terms of performance; it's a simple property access. On the other
hand, `Assembly.GetExecutingAssembly()` can take up to 30 times as long because it walks up the call stack to find the assembly.

## Noncompliant Code Example

<pre>
public class Example
{
   public static void Main()
   {
      Assembly assem = Assembly.GetExecutingAssembly(); // Noncompliant
      Console.WriteLine("Assembly name: {0}", assem.FullName);
   }
}
</pre>

## Compliant Solution

<pre>
public class Example
{
   public static void Main()
   {
      Assembly assem = typeof(Example).Assembly; // Here we use the type of the current class
      Console.WriteLine("Assembly name: {0}", assem.FullName);
   }
}
</pre>