# [Consider returning a zero length array rather than null](https://spotbugs.readthedocs.io/en/latest/bugDescriptions.html#PZLA_PREFER_ZERO_LENGTH_ARRAYS)

 It is often a better design to
return a length zero array rather than a null reference to indicate that there
are no results (i.e., an empty list of results).
This way, no explicit check for null is needed by clients of the method.

On the other hand, using null to indicate
"there is no answer to this question" is probably appropriate.
For example, `File.listFiles()` returns an empty list
if given a directory containing no files, and returns null if the file
is not a directory.