## Avoid asserts

### Problematic code:

```python
assert condition
```

### Correct code:

```python
if not condition:
    raise AssertionError()
```

### Rationale:

It was discovered that some projects used assert to enforce interface constraints. 
However, assert is removed with compiling to optimised byte code (`python -o` producing `*.pyo` files). 
This caused various protections to be removed. 
The use of assert is also considered as general bad practice in OpenStack codebases.

[Reference](https://docs.openstack.org/bandit/latest/plugins/b101_assert_used.html)