## Avoid exec

### Problematic code:

```python
s = "print(\"Hello, World!\")"
exec s
```

### Correct code:

```python
def print_hello_world():
    print("Hello, World!")

print_hello_world()
```

### Rationale:

It was discovered that some projects used assert to enforce interface constraints. 
However, assert is removed with compiling to optimised byte code (`python -o` producing `*.pyo` files). 
This caused various protections to be removed. 
The use of assert is also considered as general bad practice in OpenStack codebases.

[Reference](https://docs.openstack.org/bandit/latest/plugins/b102_exec_used.html)

See also:

* https://docs.quantifiedcode.com/python-anti-patterns/security/use_of_exec.html
* https://stackoverflow.com/questions/1933451/why-should-exec-and-eval-be-avoided

