## Avoid starting a process with no shell

Python possesses many mechanisms to invoke an external executable. 
However, doing so may present a security issue if appropriate care is not taken to sanitize any user provided or variable input.
Specifically, this test looks for the spawning of a subprocess in a way that doesn’t use a shell. 
Although this is generally safe, it maybe useful for penetration testing workflows to track where external system calls are used.


[Reference](https://docs.openstack.org/bandit/latest/plugins/b606_start_process_with_no_shell.html)