package codacy.patterns

import codacy.base.{Pattern, Result}

import scala.meta._

case object Custom_Scala_PathTraversal extends Pattern {

  def apply(tree:Tree):Set[Result] = {
    tree.collect {
      case t@q"..$mods def $name[..$tparams](..${paramss: Seq[Term.Param]}): $tpeopt = ${expr: Tree}" =>
        findOffendersInScope(expr, paramss)

      case t@q"..$mods class $name [..$tparams] (..${paramss: Seq[Term.Param]}) extends ..$supers {$body}" =>
        findOffendersInScope(body, paramss)
    }.flatten.toSet
  }

  private def findOffendersInScope(tree: Tree, paramsInScope: Seq[Term.Param]): Seq[Result] = {
    tree.collect {
      case t@init"$ctorcalls" if isOffender(ctorcalls, paramsInScope) =>
        Result(message, t)
      case t@q"Source.fromFile(..${args: Seq[Term]})" if hasOffenderParams(args, paramsInScope) =>
        Result(message, t)
      case t@q"scala.io.Source.fromFile(..${args: Seq[Term]})" if hasOffenderParams(args, paramsInScope) =>
        Result(message, t)
    }
  }

  private def isOffender(ctorCalls: Init, paramsInScope: Seq[Term.Param]): Boolean = {
    ctorCalls match {
      case init"File (..${params: Seq[Term]})" if hasOffenderParams(params, paramsInScope) =>
        true
      case init"java.io.File (..${params: Seq[Term]})" if hasOffenderParams(params, paramsInScope) =>
        true
      case init"FileReader (..${params: Seq[Term]})" if hasOffenderParams(params, paramsInScope) =>
        true
      case init"java.io.FileReader (..${params: Seq[Term]})" if hasOffenderParams(params, paramsInScope) =>
        true
      case init"FileWriter (..${params: Seq[Term]})" if hasOffenderParams(params, paramsInScope) =>
        true
      case init"java.io.FileWriter (..${params: Seq[Term]})" if hasOffenderParams(params, paramsInScope) =>
        true
      case init"RandomAccessFile (..${params: Seq[Term]})" if hasOffenderParams(params, paramsInScope) =>
        true
      case init"java.io.RandomAccessFile (..${params: Seq[Term]})" if hasOffenderParams(params, paramsInScope) =>
        true
      case init"FileInputStream (..${params: Seq[Term]})" if hasOffenderParams(params, paramsInScope) =>
        true
      case init"java.io.FileInputStream (..${params: Seq[Term]})" if hasOffenderParams(params, paramsInScope) =>
        true
      case init"FileOutputStream (..${params: Seq[Term]})" if hasOffenderParams(params, paramsInScope) =>
        true
      case init"java.io.FileOutputStream (..${params: Seq[Term]})" if hasOffenderParams(params, paramsInScope) =>
        true
      case _ =>
        false
    }
  }

  private def hasOffenderParams(params: Seq[Term], paramsInScope: Seq[Term.Param]): Boolean = {
    val namesInScope = paramsInScope.collect {
      case param"..$mods ${paramName: Name}: $_ = $_" =>
        paramName.value
    }

    val paramNames = params.collect {
      case q"${expr: Term}" =>
        expr match {
          case q"${name: Term.Name}($index)" =>
            name.toString()
          case q"${name: Term.Name}.head" =>
            name.toString()
          case q"$_ + ${name: Term.Name}" =>
            name.toString()
          case q"${name: Term.Name} + $_" =>
            name.toString()
          case q"$_ + ${name: Term.Name} $_" =>
            name.toString()
          case _ =>
            expr.toString()
        }
    }

    paramNames.headOption.exists(param => namesInScope.contains(param))
  }

  private def message = Message("Potential Path Traversal")
}