package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_PlayUntrustedHttpRequestParameter extends Pattern {

  override def apply(tree: Tree) = {
    if(hasPlayHint(tree)){
      tree.collect{
        case t@q"..${mods:Seq[Mod]} def $name[..$tparams](...${paramss: Seq[Seq[Term.Param]]}): ${tpeopt:Option[Type]}= $expr"
        if ! paramss.forall(_.isEmpty) && (tpeopt.exists(isActionTpe) || isActionExpr(expr)) =>
          Result(message, t)
      }
    }
    else Seq.empty
  }

  private[this] def isActionTpe(tpe:Type):Boolean = {
    tpe match{
      case t"${tpe:Type.Name}[..$tpesnel]" =>
        tpe.value == "Action"
      case _ =>
        false
    }
  }

  private[this] def isActionExpr(rhs:Tree):Boolean = {
    rhs match{
      case q"{ ..${stats:Seq[Stat]} }" =>
        isActionExpr(stats.last)
      case q"Action(..$aexprssnel)" =>
        true
      case q"$expr(..$aexprssnel)" =>
        isActionExpr(expr)
      case q"Action.async" =>
        true
      case _ =>
        false
    }
  }

  //this is merely to avoid false positives remove it if the pattern never encounters issues
  private[this] def hasPlayHint(tree:Tree):Boolean = {
    tree.collect{
      case importer"play.api.mvc._" => true
    }.exists(identity)
  }

  private[this] def message = Message("The method takes a value that is controlled by the client")
}
