## Brace expansion doesn't happen in `[[ ]]`. Use a loop.

### Problematic code:

```sh
[[ "$file" = index.{htm,html,php} ]] && echo "This is the main file"
```

### Correct code:

```sh
for main in index.{htm,html,php}
do
  [[ "$file" = "$main" ]] && echo "This is the main file"
done
```

### Rationale:

Brace expansions doesn't happen in `[[ ]]`. They will just be interpreted literally.

Instead, use a `for` loop to iterate over values, and apply your condition to each.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2201)

