
Because it is easy to extract strings from a compiled application, credentials should never be hard-coded. Do so, and they're almost guaranteed to<br>end up in the hands of an attacker. This is particularly true for applications that are distributed.

Credentials should be stored outside of the code in a strongly-protected encrypted configuration file or database.

## Noncompliant Code Example


    string username = "admin";
    string password = "Password123"; // Noncompliant
    string usernamePassword  = "user=admin&amp;password=Password123"; // Noncompliant
    string usernamePassword2 = "user=admin&amp;" + "password=" + password; // Noncompliant


## Compliant Solution


    string username = "admin";
    string password = GetEncryptedPassword();
    string usernamePassword = string.Format("user={0}&amp;password={1}", GetEncryptedUsername(), GetEncryptedPassword());


## See

- [OWASP Top 10 2017 Category A2](https://www.owasp.org/index.php/Top_10-2017_A2-Broken_Authentication) - Broken Authentication
- [MITRE, CWE-798](http://cwe.mitre.org/data/definitions/798) - Use of Hard-coded Credentials
- [MITRE, CWE-259](http://cwe.mitre.org/data/definitions/259) - Use of Hard-coded Password
- [CERT, MSC03-J.](https://www.securecoding.cert.org/confluence/x/qQCHAQ) - Never hard code sensitive information
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat3) - Porous Defenses
- Derived from FindSecBugs rule [Hard Coded Password](http://h3xstream.github.io/find-sec-bugs/bugs.htm#HARD_CODE_PASSWORD)

