
The MD5 algorithm and its successor, SHA-1, are no longer considered secure, because it is too easy to create hash collisions with them. That is,<br>it takes too little computational effort to come up with a different input that produces the same MD5 or SHA-1 hash, and using the new, same-hash<br>value gives an attacker the same access as if he had the originally-hashed value. This applies as well to the other Message-Digest algorithms: MD2,<br>MD4, MD6.

This rule tracks usage of the `System.Security.Cryptography.CryptoConfig.CreateFromName()`, and<br>`System.Security.Cryptography.HashAlgorithm.Create()` methods to instantiate MD5, DSA, HMACMD5, HMACRIPEMD160, RIPEMD-160 or SHA-1<br>algorithms, and of derived class instances of `System.Security.Cryptography.SHA1` and `System.Security.Cryptography.MD5`.

Consider using safer alternatives, such as SHA-256, or SHA-3.

## Noncompliant Code Example


    var hashProvider1 = new MD5CryptoServiceProvider(); //Noncompliant
    var hashProvider2 = (HashAlgorithm)CryptoConfig.CreateFromName("MD5"); //Noncompliant
    var hashProvider3 = new SHA1Managed(); //Noncompliant
    var hashProvider4 = HashAlgorithm.Create("SHA1"); //Noncompliant


## Compliant Solution


    var hashProvider1 = new SHA256Managed();
    var hashProvider2 = (HashAlgorithm)CryptoConfig.CreateFromName("SHA256Managed");
    var hashProvider3 = HashAlgorithm.Create("SHA256Managed");


## See

- [OWASP Top 10 2017 Category A6](https://www.owasp.org/index.php/Top_10-2017_A6-Security_Misconfiguration) - Security<br>  Misconfiguration
- [MITRE, CWE-328](http://cwe.mitre.org/data/definitions/328) - Reversible One-Way Hash
- [MITRE, CWE-327](http://cwe.mitre.org/data/definitions/327) - Use of a Broken or Risky Cryptographic Algorithm
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat3) - Porous Defenses
- [SHAttered](http://shattered.io/) - The first concrete collision attack against SHA-1.


## Deprecated

This rule is deprecated; use {rule:csharpsquid:S4790} instead.
