
`Enumerable.Sum()` always executes addition in a `checked` context, so an `OverflowException` will be thrown if<br>the value exceeds `MaxValue` even if an `unchecked` context was specified. Using an `unchecked` context anyway<br>represents a misunderstanding of how `Sum` works.

This rule raises an issue when an `unchecked` context is specified for a `Sum` on integer types.

## Noncompliant Code Example


    void Add(List&lt;int&gt; list)
    {
      int d = unchecked(list.Sum());  // Noncompliant
    
      unchecked
      {
        int e = list.Sum();  // Noncompliant
      }
    }


## Compliant Solution


    void Add(List&lt;int&gt; list)
    {
      int d = list.Sum();
    
      try
      {
        int e = list.Sum();
      }
      catch (System.OverflowException e)
      {
        // exception handling...
      }
    }


## Exceptions

When the `Sum()` call is inside a `try-catch` block, no issues are reported.


    void Add(List&lt;int&gt; list)
    {
      unchecked
      {
        try
        {
          int e = list.Sum();
        }
        catch (System.OverflowException e)
        {
          // exception handling...
        }
      }
    }

