
Curly braces can be omitted from a one-line block, such as with an `if` statement or `for` loop, but doing so can be<br>misleading and induce bugs.

This rule raises an issue when the whitespacing of the lines after a one line block indicates an intent to include those lines in the block, but<br>the omission of curly braces means the lines will be unconditionally executed once.

## Noncompliant Code Example


    if (condition)
      FirstActionInBlock();
      SecondAction();  // Noncompliant; executed unconditionally
    ThirdAction();
    
    if(condition) FirstActionInBlock(); SecondAction();  // Noncompliant; secondAction executed unconditionally
    
    if(condition) FirstActionInBlock();  // Noncompliant
      SecondAction();  // Executed unconditionally
    
    string str = null;
    for (int i = 0; i &lt; array.Length; i++)
      str = array[i];
      DoTheThing(str);  // Noncompliant; executed only on last array element


## Compliant Solution


    if (condition)
    {
      FirstActionInBlock();
      SecondAction();
    }
    ThirdAction();
    
    string str = null;
    for (int i = 0; i &lt; array.Length; i++)
    {
      str = array[i];
      DoTheThing(str);
    }


## See

- [MITRE, CWE-483](http://cwe.mitre.org/data/definitions/483.html) - Incorrect Block Delimitation
- [CERT, EXP52-J.](https://www.securecoding.cert.org/confluence/x/3wHEAw) - Use braces for the body of an if, for, or while statement<br>

