
Typically you want to use `using` to create a local `IDisposable` variable; it will trigger disposal of the object when<br>control passes out of the block's scope. The exception to this rule is when your method returns that `IDisposable`. In that case<br>`using` disposes of the object before the caller can make use of it, likely causing exceptions at runtime. So you should either remove<br>`using` or avoid returning the `IDisposable`.

## Noncompliant Code Example


    public FileStream WriteToFile(string path, string text)
    {
      using (var fs = File.Create(path)) // Noncompliant
      {
        var bytes = Encoding.UTF8.GetBytes(text);
        fs.Write(bytes, 0, bytes.Length);
        return fs;
      }
    }


## Compliant Solution


    public FileStream WriteToFile(string path, string text)
    {
      var fs = File.Create(path);
      var bytes = Encoding.UTF8.GetBytes(text);
      fs.Write(bytes, 0, bytes.Length);
      return fs;
    }

