
Changing or bypassing accessibility is security-sensitive. For example, it has led in the past to the following vulnerability:

- [CVE-2012-4681](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2012-4681)


`private` methods were made `private` for a reason, and the same is true of every other visibility level. Altering or<br>bypassing the accessibility of classes, methods, or fields violates the encapsulation principle and could introduce security holes.

This rule raises an issue when reflection is used to change the visibility of a class, method or field, and when it is used to directly update a<br>field value.

## Ask Yourself Whether

- there is a good reason to override the existing accessibility level of the method/field. This is very rarely the case. Accessing hidden fields<br>  and methods will make your code unstable as they are not part of the public API and may change in future versions.
- this method is called by untrusted code. **\***
- it is possible to modify or bypass the accessibility of sensitive methods or fields using this code. **\***


**\*** You are at risk if you answered yes to those questions.

## Recommended Secure Coding Practices

Don't change or bypass the accessibility of any method or field if possible.

If untrusted code can execute this method, make sure that it cannot decide which method or field's accessibility can be modified or bypassed.

## Sensitive Code Example


    using System.Reflection;
    
    Type dynClass = Type.GetType("MyInternalClass");
    // Sensitive. Using BindingFlags.NonPublic will return non-public members
    BindingFlags bindingAttr = BindingFlags.NonPublic | BindingFlags.Static;
    MethodInfo dynMethod = dynClass.GetMethod("mymethod", bindingAttr);
    object result = dynMethod.Invoke(dynClass, null);


## See

- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>
- [CERT, SEC05-J.](https://www.securecoding.cert.org/confluence/x/3YEVAQ) - Do not use reflection to increase accessibility of<br>  classes, methods, or fields

