
Unnecessarily verbose declarations and initializations make it harder to read the code, and should be simplified.

Specifically the following should be omitted when they can be inferred:

- array element type
- array size
- `new DelegateType`
- `new Nullable<Type>`
- object or collection initializers (`{}`)
- type of lambda expression parameters
- parameter declarations of anonymous methods when the parameters are not used.


## Noncompliant Code Example


    var l = new List&lt;int&gt;() {}; // Noncompliant, {} can be removed
    var o = new object() {}; // Noncompliant, {} can be removed
    
    var ints = new int[] {1, 2, 3}; // Noncompliant, int can be omitted
    ints = new int[3] {1, 2, 3}; // Noncompliant, the size specification can be removed
    
    int? i = new int?(5); // Noncompliant new int? could be omitted, it can be inferred from the declaration, and there's implicit conversion from T to T?
    var j = new int?(5);
    
    Func&lt;int, int&gt; f1 = (int i) =&gt; 1; //Noncompliant, can be simplified
    
    class Class
    {
        private event EventHandler MyEvent;
    
        public Class()
        {
            MyEvent += new EventHandler((a,b)=&gt;{ }); // Noncompliant, needlessly verbose
        }
    }


## Compliant Solution


    var l = new List&lt;int&gt;();
    var o = new object();
    
    var ints = new [] {1, 2, 3};
    ints = new [] {1, 2, 3};
    
    int? i = 5;
    var j = new int?(5);
    
    Func&lt;int, int&gt; f1 = (i) =&gt; 1;
    
    class Class
    {
        private event EventHandler MyEvent;
    
        public Class()
        {
            MyEvent += (a,b)=&gt;{ };
        }
    }

