
When declaring a Windows Communication Foundation (WCF) `OperationContract` method one-way, that service method won't return any result,<br>not even an underlying empty confirmation message. These are fire-and-forget methods that are useful in event-like communication. Specifying a return<br>type therefore does not make sense.

## Noncompliant Code Example


    [ServiceContract]
    interface IMyService
    {
      [OperationContract(IsOneWay = true)]
      int SomethingHappened(int parameter); // Noncompliant
    }


## Compliant Solution


    [ServiceContract]
    interface IMyService
    {
      [OperationContract(IsOneWay = true)]
      void SomethingHappened(int parameter);
    }


## Exceptions

The rule doesn't report if `OperationContractAttribute.AsyncPattern` is set to `true`.
