
ASP.Net has a feature to validate HTTP requests to prevent potentially dangerous content to perform a cross-site scripting (XSS) attack. There is<br>no reason to disable this mechanism even if other checks to prevent XXS attacks are in place.

This rule raises an issue if a method with parameters is marked with `System.Web.Mvc.HttpPostAttribute` and not<br>`System.Web.Mvc.ValidateInputAttribute(true)`.

## Noncompliant Code Example


    public class FooBarController : Controller
    {
        [HttpPost] // Noncompliant
        [ValidateInput(false)]
        public ActionResult Purchase(string input)
        {
            return Foo(input);
        }
    
        [HttpPost] // Noncompliant
        public ActionResult PurchaseSomethingElse(string input)
        {
            return Foo(input);
        }
    }


## Compliant Solution


    public class FooBarController : Controller
    {
        [HttpPost]
        [ValidateInput(true)] // Compliant
        public ActionResult Purchase(string input)
        {
            return Foo(input);
        }
    }


## Exceptions

Parameterless methods marked with `System.Web.Mvc.HttpPostAttribute` will not trigger this issue.

## See

- [OWASP Top 10 2017 Category A7](https://www.owasp.org/index.php/Top_10-2017_A7-Cross-Site_Scripting_%28XSS%29) - Cross-Site Scripting<br>  (XSS)
- [MITRE, CWE-79](http://cwe.mitre.org/data/definitions/79) - Improper Neutralization of Input During Web Page Generation ('Cross-site<br>  Scripting')
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat1) - Insecure Interaction Between Components
- [OWASP ASP.NET Request Validation](https://www.owasp.org/index.php/ASP.NET_Request_Validation)

