## Avoid pass in the except block

### Example:

```python
try:
  do_some_stuff()
except Exception:
  pass
```


### Rationale:

This pattern is considered bad practice in general, but also represents a potential security issue. A larger than normal volume of errors from a service can indicate an attempt is being made to disrupt or interfere with it. Thus errors should, at the very least, be logged.

There are rare situations where it is desirable to suppress errors, but this is typically done with specific exception types, rather than the base Exception class (or no type).

[Reference](https://docs.openstack.org/bandit/latest/plugins/b110_try_except_pass.html)

