### AddMissingTypeInheritanceDemandRule
The rule checks for types that are not **sealed** but have a **LinkDemand**. In this case the type should also have an **InheritanceDemand** for the same permissions. An alternative is to seal the type.

**Bad** example:

``` csharp
[SecurityPermission (SecurityAction.LinkDemand, ControlThread = true)]
public class Bad {
}
```
**Good** example (InheritanceDemand):

``` csharp
[SecurityPermission (SecurityAction.LinkDemand, ControlThread = true)]
[SecurityPermission (SecurityAction.InheritanceDemand, ControlThread = true)]
public class Correct {
}
```
**Good** example (sealed):

``` csharp
[SecurityPermission (SecurityAction.LinkDemand, ControlThread = true)]
public sealed class Correct {
}
```
**Notes**

-   Before Gendarme 2.2 this rule was part of Gendarme.Rules.Security and named TypeLinkDemandRule.
