### AttributeArgumentsShouldHaveAccessorsRule
This rule fires if a parameter to an **Attribute** constructor is not exposed using a properly cased property. This is a problem because it is generally not useful to set state within an attribute without providing a way to get at that state.

**Bad** example:

``` csharp
[AttributeUsage (AttributeTargets.All)]
public sealed class AttributeWithRequiredProperties : Attribute {
    private int storedFoo;
    private string storedBar;
 
    // we have no corresponding property with the name 'Bar' so the rule will fail
    public AttributeWithRequiredProperties (int foo, string bar)
    {
        storedFoo = foo;
        storedBar = bar;
    }
 
    public int Foo {
        get {
            return storedFoo;
        }
    }
}
```
**Good** example:

``` csharp
[AttributeUsage (AttributeTargets.All)]
public sealed class AttributeWithRequiredProperties : Attribute {
    private int storedFoo;
    private string storedBar;
 
    public AttributeWithRequiredProperties (int foo, string bar)
    {
        storedFoo = foo;
        storedBar = bar;
    }
 
    public int Foo {
        get {
            return storedFoo;
        }
    }
 
    public string Bar {
        get {
            return storedBar;
        }
    }
}
```