### AvoidCodeDuplicatedInSameClassRule
This rule checks for duplicated code in the same class.

**Bad** example:

``` csharp
public class MyClass {
    private IList myList;
 
    public MyClass () {
        myList = new ArrayList ();
        myList.Add ("Foo");
        myList.Add ("Bar");
        myList.Add ("Baz");
    }
 
    public void MakeStuff () {
        foreach (string value in myList) {
            Console.WriteLine (value);
        }
        myList.Add ("FooReplied");
    }
 
    public void MakeMoreStuff () {
        foreach (string value in myList) {
            Console.WriteLine (value);
        }
        myList.Remove ("FooReplied");
    }
}
```
**Good** example:

``` csharp
public class MyClass {
    private IList myList;
 
    public MyClass () {
        myList = new ArrayList ();
        myList.Add ("Foo");
        myList.Add ("Bar");
        myList.Add ("Baz");
    }
 
    private void PrintValuesInList () {
        foreach (string value in myList) {
            Console.WriteLine (value);
        }
    }
 
    public void MakeStuff () {
        PrintValuesInList ();
        myList.Add ("FooReplied");
    }
 
    public void MakeMoreStuff () {
        PrintValuesInList ();
        myList.Remove ("FooReplied");
    }
}
```