### AvoidEmptyInterfaceRule
This rule fires if an interface declares no members. Empty interfaces are generally not useful except as markers to categorize types and attributes are the preferred way to handle that.

**Bad** example:

``` csharp
public interface IMarker {
}
 
public class MyClass : IMarker {
}
```
**Good** example:

``` csharp
[MarkedByAnAttribute]
public class MyClass {
}
```