### AvoidLargeStructureRule
This rule will fire if a value type (struct in C#) is larger than a maximum value (16 bytes by default). This is a problem because, unlike reference types, value types are bitwise-copied whenever they are assigned to a variable or passed to a method. If the type cannot be reduced in size then it should be turned into a reference type (class in C#).

**Bad** example:

``` csharp
public struct BigArgb {
    long a, r, g, b;
}
```
**Good** example:

``` csharp
public sealed class BigArgb {
    long a, r, g, b;
}
```
**Notes**

-   This rule is available since Gendarme 2.0

**Configuration**

Some elements of this rule can be customized to better fit your needs.

#### MaxSize
The maximum size structs may be without a defect.
