### AvoidNonAlphanumericIdentifierRule
This rule ensures that identifiers like assembly names, namespaces, types and members names don't have any non-alphanumerical characters inside them. The rule will ignore interfaces used for COM interoperability - i.e. decorated with both **[InterfaceType]** and **[Guid]** attributes.

**Bad** example:

``` csharp
namespace New_Namespace {
 
    public class My_Custom_Class {
 
        public int My_Field;
 
        public void My_Method (string my_string)
        {
        }
    }
}
```
**Good** example:

``` csharp
namespace NewNamespace {
 
    public class MyCustomClass {
 
        public int MyField;
 
        public void MyMethod (string myString)
        {
        }
    }
}
```
**Notes**

-   Prior to Gendarme 2.2 this rule was named DetectNonAlphanumericInTypeNamesRule
