### AvoidRefAndOutParametersRule
This rule fires if a method uses **ref** or **out** parameters. These are advanced features that can easily be misunderstood (by the consumer) and misused (by the consumer) and can result in an API that is difficult to use. Avoid them whenever possible or, if needed, provide simpler alternatives for most use cases. An exception is made, i.e. no defect are reported, for the **bool Try\*(X out)** pattern.

**Bad** example:

``` csharp
public bool NextJob (ref int id, out string display)
{
    if (id < 0)
    return false;
    display = String.Format ("Job #{0}", id++);
    return true;
}
```
**Good** example:

``` csharp
private int id = 0;
 
private int GetNextId ()
{
    int id = this.id++;
    return id;
}
 
public string NextJob ()
{
    return String.Format ("Job #{0}", Id);
}
```
**Notes**

-   This rule is available since Gendarme 2.0
