### AvoidUncalledPrivateCodeRule
This rule will check for internally visible methods which are never called. The rule will warn you if a private method isn't called in its declaring type or if an internal method doesn't have any callers in the assembly or isn't invoked by the runtime or a delegate.

**Bad** example:

``` csharp
public class MyClass {
    private void MakeSuff ()
    {
        // ...
    }
 
    public void Method ()
    {
        Console.WriteLine ("Foo");
    }
}
```
**Good** example (removing unused code):

``` csharp
public class MyClass {
    public void Method ()
    {
        Console.WriteLine ("Foo");
    }
}
```
**Good** example (use the code):

``` csharp
public class MyClass {
    private void MakeSuff ()
    {
        // ...
    }
 
    public void Method ()
    {
        Console.WriteLine ("Foo");
        MakeSuff ();
    }
}
```