### AvoidUnnecessarySpecializationRule
This rule checks methods for over specialized parameters - i.e. parameter types that are unnecessarily specialized with respect to what the method needs to perform its job. This often impairs the reusability of the method. If a problem is found the rule will suggest the most general type, or interface, required for the method to work.

**Bad** example:

``` csharp
public class DefaultEqualityComparer : IEqualityComparer {
    public int GetHashCode (object obj)
    {
        return o.GetHashCode ();
    }
}
 
public int Bad (DefaultEqualityComparer ec, object o)
{
    return ec.GetHashCode (o);
}
```
**Good** example:

``` csharp
public class DefaultEqualityComparer : IEqualityComparer {
    public int GetHashCode (object obj)
    {
        return o.GetHashCode ();
    }
}
 
public int Good (IEqualityComparer ec, object o)
{
    return ec.GetHashCode (o);
}
```
**Notes**

-   This rule is available since Gendarme 2.0
