### CallingEqualsWithNullArgRule
This rule checks for methods that call **Equals** with a **null** actual parameter. Such calls should always return **false**.

**Bad** example:

``` csharp
public void MakeStuff ()
{
    MyClass myClassInstance = new MyClass ();
    MyClass otherClassInstance = null;
    Console.WriteLine (myClassInstance.Equals (otherClassInstance));
}
```
**Good** example:

``` csharp
public void MakeStuff ()
{
    MyClass myClassInstance = new MyClass ();
    MyClass otherClassInstance = new MyClass ();
    Console.WriteLine (myClassInstance.Equals (otherClassInstance));
}
```