### CompareWithEmptyStringEfficientlyRule
This rule will fire if a string is compared to **""** or **String.Empty**. Instead use a **String.Length** test which should be a bit faster. Another possibility (with .NET 2.0) is to use the static **String.IsNullOrEmpty** method. **String.IsNullOrEmpty**.

**Bad** example:

``` csharp
public void SimpleMethod (string myString)
{
    if (myString.Equals (String.Empty)) {
    }
}
```
**Good** example:

``` csharp
public void SimpleMethod (string myString)
{
    if (myString.Length == 0) {
    }
}
```