### DisposableFieldsShouldBeDisposedRule
The rule inspects all fields for disposable types and, if **System.IDisposable** is implemented, checks that the type's **Dispose** method does indeed call **Dispose** on all disposable fields.

**Bad** example:

``` csharp
class DoesNotDisposeMember : IDisposable {
    byte[] buffer;
    IDisposable field;
 
    public void Dispose ()
    {
        buffer = null;
        // field is not disposed
    }
}
```
**Good** example:

``` csharp
class DisposePattern : IDisposable {
    byte[] buffer;
    IDisposable field;
    bool disposed;
 
    public void Dispose ()
    {
        Dispose (true);
    }
 
    private void Dispose (bool disposing)
    {
        if (!disposed) {
            if (disposing) {
                field.Dispose ();
            }
            buffer = null;
            disposed = true;
        }
    }
}
```