### DisposableTypesShouldHaveFinalizerRule
This rule will fire for types which implement **System.IDisposable**, contain native fields such as **System.IntPtr**, **System.UIntPtr**, and **System.Runtime.InteropServices.HandleRef**, but do not define a finalizer.

**Bad** example:

``` csharp
class NoFinalizer {
    IntPtr field;
}
```
**Good** example:

``` csharp
class HasFinalizer {
    IntPtr field;
 
    ~HasFinalizer ()
    {
        UnmanagedFree (field);
    }
}
```