### DoNotDeclareVirtualMethodsInSealedTypeRule
This rule ensure that **sealed** types (i.e. types that you can't inherit from) do not define new **virtual** methods. Such methods would only be useful in sub-types. Note that some compilers, like C# and VB.NET compilers, do not allow you to define such methods.

**Bad** example:

``` csharp
public sealed class MyClass {
    // note that C# compilers won't allow this to compile
    public virtual int GetAnswer ()
    {
        return 42;
    }
}
```
**Good** example:

``` csharp
public sealed class MyClass {
    public int GetAnswer ()
    {
        return 42;
    }
}
```