### DoNotHardcodePathsRule
This rule checks for strings that contain valid paths, either under Unix or Windows file systems. Path literals are often not portable across operating systems (e.g. different path separators). To ensure correct cross-platform functionality they should be replaced by calls to **Path.Combine** and/or **Environment.GetFolderPath**.

**Bad** example:

``` csharp
void ReadConfig ()
{
    using (FileStream fs = File.Open ("~/.local/share/myapp/user.config")) {
        // read configuration
    }
}
```
**Good** example:

``` csharp
void ReadConfig ()
{
    string config_file = Environment.GetFolderPath (SpecialFolder.LocalApplicationData);
    config_file = Path.Combine (Path.Combine (config_file, "myapp"), "user.config");
    using (FileStream fs = File.Open (config_file)) {
        // read configuration
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.0
