### DoNotShortCircuitCertificateCheckRule
This rule checks for methods that implements pass-through certificate checks. I.e. methods that override the framework decision about a certificate validity without checking anything specific about the supplied certificate or error code. Protocols like TLS/SSL are only secure if the certificates are used correctly.

**Bad** example (ICertificatePolicy):

``` csharp
public class AcceptEverythingCertificatePolicy : ICertificatePolicy {
    public bool CheckValidationResult (ServicePoint srvPoint, X509Certificate certificate, WebRequest request, int certificateProblem)
    {
        // this accepts everything making it easy for MITM
        // (Man-in-the-middle) attacks
        return true;
    }
}
```
**Good** example (ICertificatePolicy):

``` csharp
public class AllowSpecificCertificatePolicy : ICertificatePolicy {
    public bool CheckValidationResult (ServicePoint srvPoint, X509Certificate certificate, WebRequest request, int certificateProblem)
    {
        // this accept only a specific certificate, even if others would be ok
        return (certificate.GetCertHashString () == "D62F48D013EE7FB58B79074512670D9C5B3A5DA9");
    }
}
```
**Bad** example (RemoteCertificateValidationCallback):

``` csharp
public bool CertificateValidationCallback (object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors)
{
    // this accepts everything making it easy for MITM
    // (Man-in-the-middle) attacks
    return true;
}
 
SslStream ssl = new SslStream (stream, false, new RemoteCertificateValidationCallback (CertificateValidationCallback), null);
```
**Good** example (RemoteCertificateValidationCallback):

``` csharp
public bool CertificateValidationCallback (object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors)
{
    // this accept only a specific certificate, even if others would be ok
    return (certificate.GetCertHashString () == "D62F48D013EE7FB58B79074512670D9C5B3A5DA9");
}
 
SslStream ssl = new SslStream (stream, false, new RemoteCertificateValidationCallback (CertificateValidationCallback), null);
```
**Notes**

-   This rule is available since Gendarme 2.4
