### DoNotThrowInUnexpectedLocationRule
There are a number of methods which have constraints on the exceptions which they may throw. This rule checks the following methods:

-   Property getters - properties should work very much like fields: they should execute very quickly and, in general, should not throw exceptions. However they may throw System.InvalidOperationException, System.NotSupportedException, or an exception derived from these. Indexed getters may also throw System.ArgumentException or System.Collections.Generic.KeyNotFoundException.
-   Event accessors - in general events should not throw when adding or removing a handler. However they may throw System.InvalidOperationException, System.NotSupportedException, System.ArgumentException, or an exception derived from these.
-   Object.Equals and IEqualityComparer\<T\>.Equals - should not throw. In particular they should do something sensible when passed null arguments or unexpected types.
-   Object.GetHashCode - should not throw or the object will not work properly with dictionaries and hash sets.
-   IEqualityComparer\<T\>.GetHashCode - may throw System.ArgumentException.
-   Object.ToString - these are called by the debugger to display objects and are also often used with printf style debugging so they should not change the object's state and should not throw.
-   static constructors - should very rarely throw. If they do throw then the type will not be useable within that application domain.
-   finalizers - should not throw. If they do (as of .NET 2.0) the process will be torn down.
-   IDisposable.Dispose - should not throw. If they do it's much harder to guarantee that objects clean up properly.
-   Dispose (bool) - should not throw because that makes it very difficult to clean up objects and because they are often called from a finalizer.
-   operator== and operator!= - should not throw. In particular they should do something sensible when passed null arguments or unexpected types.
-   implicit cast operators - should not throw. These methods are called implicitly so it tends to be quite surprising if they throw exceptions.

Note that the rule does not complain if a method throws System.NotImplementedException because DoNotForgetNotImplementedMethodsRule will flag them. Also the rule may fire with anonymous types with gmcs versions prior to 2.2, see [[1]](https://bugzilla.novell.com/show_bug.cgi?id=462622) for more details.

**Bad** example:

``` csharp
public override bool Equals (object obj)
{
    if (obj == null) {
        return false;
    }
 
    Customer rhs = (Customer) obj;  // throws if obj is not a Customer
    return name == rhs.name;
}
```
**Good** example:

``` csharp
public override bool Equals (object obj)
{
    Customer rhs = obj as Customer;
    if (rhs == null) {
        return false;
    }
 
    return name == rhs.name;
}
```
**Notes**

-   This rule is available since Gendarme 2.4
