### EnsureSymmetryForOverloadedOperatorsRule
This rule checks for operators that are not overloaded in pairs. Some compilers, like the C# compilers, require you to implement some of the pairs, but other languages might not. The following pairs are checked:

**Bad** example:

``` csharp
class DoesNotOverloadAdd {
    public static int operator - (DoesNotOverloadAdd left, DoesNotOverloadAdd right)
    {
        return 0;
    }
}
```
**Good** example:

``` csharp
class Good {
    public static int operator + (Good right, Good left)
    {
        return 0;
    }
 
    public static int operator - (Good right, Good left)
    {
        return 0;
    }
}
```