### FinalizersShouldBeProtectedRule
This rule verifies that finalizers are only visible to the type's family (e.g. protected in C#). If they are not family then they can be called from user code which could lead to problems. Note that this restriction is enforced by the C# and VB.NET compilers but other compilers may not do so.

**Bad** example (IL):

``` csharp
.class family auto ansi beforefieldinit BadPublicFinalizer extends
[mscorlib]System.Object
{
    .method public hidebysig instance void Finalize() cil managed
    {
        // ...
    }
}
```
**Good** example (C#):

``` csharp
public class GoodProtectedFinalizer {
    // compiler makes it protected
    ~GoodProtectedFinalizer ()
    {
    }
}
```
**Good** example (IL):

``` csharp
.class family auto ansi beforefieldinit GoodProtectedFinalizer extends
[mscorlib]System.Object
{
    .method family hidebysig instance void Finalize() cil managed
    {
        // ...
    }
}
```