### MarkEnumerationsAsSerializableRule
This rule warns when it founds an **enum** that is not decorated with a **[Serializable]** attribute. Enums, even without the attribute, are always serializable. Marking them as such makes the source code more readable.

**Bad** example:

``` csharp
public enum Colors {
    Black,
    White
}
```
**Good** example:

``` csharp
[Serializable]
public enum Colors {
    Black,
    White
}
```
**Notes**

-   This rule is available since Gendarme 2.2
