### MathMinMaxCandidateRule
This rule checks methods for code which seems to duplicate **Math.Min** or **Math.Max**. The JIT can inline these methods and generate better code for, at least some types, than it can for a custom inline implementation.

**Bad** example:

``` csharp
int max = (a > b) ? a : b;
```
**Good** example:

``` csharp
int max = Math.Max (a, b);
```
**Notes**

-   This rule is available since Gendarme 2.0
