### MissingSerializableAttributeOnISerializableTypeRule
This rule checks for types that implement **System.ISerializable** but are not decorated with the **[Serializable]** attribute. Implementing **System.ISerializable** is not enough to make a class serializable as this interface only gives you more control over the basic serialization process. In order for the runtime to know your type is serializable it must have the **[Serializable]** attribute.

**Bad** example:

``` csharp
// this type cannot be serialized by the runtime
public class Bad : ISerializable {
}
```
**Good** example:

``` csharp
[Serializable]
public class Good : ISerializable {
}
```
**Notes**

-   This rule is available since Gendarme 2.0
