### NewLineLiteralRule
This rule warns if methods, including properties, are using the literal **\\r** and/or **\\n** for new lines. This isn't portable across operating systems. To ensure correct cross-platform functionality they should be replaced by **System.Environment.NewLine**.

**Bad** example:

``` csharp
Console.WriteLine ("Hello,\nYou should be using Gendarme!");
```
**Good** example:

``` csharp
Console.WriteLine ("Hello,{0}You must be using Gendarme!", Environment.NewLine);
```
Feedback
========
Please report any documentation errors, typos or suggestions to the [Gendarme Google Group](http://groups.google.com/group/gendarme). Thanks!
