### ObsoleteMessagesShouldNotBeEmptyRule
This rule warns if any type (including classes, structs, enums, interfaces and delegates), field, property, events, method and constructor are decorated with an empty **[Obsolete]** attribute because the attribute is much more helpful if it includes advice on how to deal with the situation (e.g. the new recommended API to use).

**Bad** example:

``` csharp
[Obsolete]
public byte[] Key {
    get {
        return (byte[]) key.Clone ();
    }
}
```
**Good** example:

``` csharp
[Obsolete ("Use the new GetKey() method since properties should not return arrays.")]
public byte[] Key {
    get {
        return (byte[]) key.Clone ();
    }
}
```