### PreferEmptyInstanceOverNullRule
This rule checks that all methods and properties which return a string, an array, a collection, or an enumerable do not return **null**. It is usually better to return an empty instance, as this allows the caller to use the result without having to perform a null-check first.

**Bad** example (string):

``` csharp
public string DisplayName {
    get {
        if (IsAnonymous) {
            return null;
        }
        return name;
    }
}
```
**Good** example (string):

``` csharp
public string DisplayName {
    get {
        if (IsAnonymous) {
            return string.Empty;
        }
        return name;
    }
}
```
**Bad** example (array):

``` csharp
public int [] GetOffsets ()
{
    if (!store.HasOffsets) {
        return null;
    }
    store.LoadOffsets ();
    return store.Offsets;
}
```
**Good** example (array):

``` csharp
static const int [] Empty = new int [0];
public int [] GetOffsets ()
{
    if (!store.HasOffsets) {
        return Empty;
    }
    store.LoadOffsets ();
    return store.Offsets.ToArray ();
}
```
**Bad** example (enumerable):

``` csharp
public IEnumerable<int> GetOffsets ()
{
    if (!store.HasOffsets) {
        return null;
    }
    store.LoadOffsets ();
    return store.Offsets;
}
```
**Good** example (enumerable):

``` csharp
public IEnumerable<int> GetOffsets ()
{
    if (!store.HasOffsets) {
        yield break;
    }
    store.LoadOffsets ();
    foreach (int offset in store.Offsets) {
        yield return offset;
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.4
